sudo -s

function log() {
    echo "$(hostname) [$(date)]: $*"
}

function logerr() {
    log "$*" >&2
}

NOW="$(date +%s)"
log "Backing up consul"
consul kv export > "/root/consul-kv.backup.$NOW.json"

# Validate that the consul backup is good
if ! jq . < "/root/consul-kv.backup.$NOW.json" &>/dev/null; then
    logerr "consul kv backup failed"
    exit 1
fi

sudo puppet agent --disable "toachris - VIDCS-1595 - nuking the world"

# Kill any active puppet runs
pkill -f '/usr/bin/ruby /usr(/local|)/bin/puppet agent'

log "leaving consul gracefully"
consul leave

log "stop consul in case it didn't work"
systemctl stop consul

log "Backup states"
mv /var/lib/consul/serf{,".backup.${NOW}"}
mv /var/lib/consul/raft{,".backup.${NOW}"}

pgrep -f /usr/bin/consul &>/dev/null && logerr "CONSUL STILL EXIST"
[[ -d /var/lib/consul/proxy || -d /var/lib/consul/serf ]] && logerr "CONSUL DATA STILL EXIST"

log "$(date) Done nuking"
