sudo -s

function log() {
    echo "$(hostname) [$(date)]: $*"
}

function logerr() {
    log "$*" >&2
}

if [[ -f /tmp/puppet-disabled ]]; then
    log "Puppet previously disabled, leaving as is."
    rm -f /tmp/puppet-disabled
else
    log "Enabled puppet"
    puppet agent --enable
fi

# Make sure to start puppet daemon on kontrons
[[ -f /etc/redhat-release ]] && systemctl start puppet

if [[ -f /tmp/consul-template-enableme ]]; then
    log "Starting consul-template"
    rm -f /etc/service/consul-template/down
    svc -u /etc/service/consul-template

    sleep 5
    pgrep consul-template &>/dev/null || logerr "ALERT: consul-template did not start!"
else
    log "consul-template not previously enabled"
fi

log "Done starting consul-template"
