sudo -s

function log {
    echo "$(date): $*"
}

PUPPET_DISABLE_MESSAGE="yangan - VIDCS-1812 - nuking the world"
if [[ -f /var/lib/puppet/state/agent_disabled.lock ]]; then
    if [[ -f /tmp/puppet-disabled ]] && ! grep -q "$PUPPET_DISABLE_MESSAGE" /var/lib/puppet/state/agent_disabled.lock 2>/dev/null; then
        echo "Puppet previously disabled"
        touch /tmp/puppet-disabled
    fi
else
    puppet agent --disable "$PUPPET_DISABLE_MESSAGE"
    pkill -f '/usr/bin/ruby /usr(/local|)/bin/puppet agent'

    # For the love of kontrons which runs puppet as a daemon
    [[ -f /etc/redhat-release ]] && pkill -9 -f 'puppet agent: applying configuration'
fi

log "stopping consul-template if this is a thing"

attempt=0

if pgrep consul-template &>/dev/null; then
    log "consul-template running, stopping"
    touch /tmp/consul-template-enableme
    svc -di /etc/service/consul-template
    touch /etc/service/consul-template/down

    count=0

    while pgrep consul-template &>/dev/null; do
        log "consul-template not dead yet..."
        sleep 2
        (( count++ ))
        (( attempt++ ))

        if [[ $count -gt 5 ]]; then
            log "force kill consul-template"
            pkill -9 consul-template
        fi

        [[ $attempt -gt 30 ]] && log "FAILED TO STOP consul-template" >&2 && exit 1
    done

    log "Done stopping consul-template: $(hostname -f)"
else
    log "consul-template not running"
fi

