#!/bin/bash
set -uex

OUTPUT_DIR="/build/output/"
CONSUL_VERSION="1.9.3"
HASHICORP_GPG_KEY_ID="51852D87348FFC4C"

PKG_ARCH=x86_64
PKG_COMMON_PARAMS="--conflicts consul --provides consul --replaces consul"
PKG_DEB_PARAMS="--deb-priority standard -m video-coreservices@twitch.tv --category admin --url https://git.xarth.tv/video-coreservices/consul-package"
PKG_DESCRIPTION="Consul is a distributed application discovery and configuration system. This package is for installing the files required to run Consul as a server or client."
PKG_NAME="dta-consul"

cd /tmp

[ -n "${http_proxy:-}" ] && keyserver_options="--keyserver-options http-proxy=$http_proxy"

echo "Checking SHA Sums"
curl -Os https://releases.hashicorp.com/consul/${CONSUL_VERSION}/consul_${CONSUL_VERSION}_SHA256SUMS
curl -Os https://releases.hashicorp.com/consul/${CONSUL_VERSION}/consul_${CONSUL_VERSION}_SHA256SUMS.sig
gpg --keyserver na.pool.sks-keyservers.net ${keyserver_options:-} --recv ${HASHICORP_GPG_KEY_ID}
gpg --verify consul_${CONSUL_VERSION}_SHA256SUMS{.sig,}

echo "Downloading consul and verifying the SHA"
consul_zip="consul_${CONSUL_VERSION}_linux_amd64.zip"
curl -Os https://releases.hashicorp.com/consul/${CONSUL_VERSION}/$consul_zip
grep $consul_zip consul_${CONSUL_VERSION}_SHA256SUMS | sha256sum -c -

echo "Creating package from binary"
unzip $consul_zip
strip consul
rm -rf "$OUTPUT_DIR"
mkdir -p "$OUTPUT_DIR"
mkdir -p /tmp/fpm_dir/usr/bin
mv /tmp/consul /tmp/fpm_dir/usr/bin

[ -n "${BUILD_ID:-}" ] && iteration="--iteration $BUILD_ID"
fpm -s dir -t deb -n $PKG_NAME -v $CONSUL_VERSION ${iteration:-} -a $PKG_ARCH $PKG_DEB_PARAMS \
    --description "$PKG_DESCRIPTION" $PKG_COMMON_PARAMS -p "$OUTPUT_DIR" -C /tmp/fpm_dir/
fpm -s dir -t rpm -n $PKG_NAME -v $CONSUL_VERSION ${iteration:-} -a $PKG_ARCH \
    --description "$PKG_DESCRIPTION" $PKG_COMMON_PARAMS  -p "$OUTPUT_DIR" -C /tmp/fpm_dir/
chown -R --reference=/build/ "$OUTPUT_DIR"
