#!/bin/bash

set -eux -o pipefail

VERSION="2019031302"

package_name="dns-root-data-debian-${VERSION}"
url="https://salsa.debian.org/dns-team/dns-root-data/-/archive/debian/${VERSION}/${package_name}.tar.gz"

wget -q -O - "$url" | tar xzf -
mv "$package_name" dns-root-data

pushd dns-root-data
dpkg-buildpackage -us -uc

popd

mkdir -p "$BUILD_ROOT"
mv "dns-root-data_${VERSION}_all.deb" /build/
