# go-statsd-proxy

A consistent hashing proxy layer for StatsD, written in Go.
This component ensures that StatsD metrics are sent and aggregated on the
same nodes given the same key, so that metrics are not duplicated and dropped.

## Architecture

Traffic to this application is accepted by a Network Load Balancer (NLB),
which accepts and balances UDP traffic across instances of this application.

At the time of this writing, NLB for UDP traffic only supports routing to
_EC2 instances_, so we cannot run multiple instances of this application
on a single EC2 instance.

This means that we cannot use AWS Fargate to run this application.

![Architecture Diagram](./docs/architecture-proxy.svg)

## Deploying

**TODO**: Update deployment mechanism

go-statsd-proxy terraform is imported from the repo that makes use of it (as of this writing only `graphql`) so this repo only handles making the _image_ for go-statsd-proxy and not the deploy.

A general deploy looks like:

1. If new code changes made: merge the changes to master, and then copy the new image tag from [the Jenkins build](https://jenkins.internal.justin.tv/job/edge/job/go-statsd-proxy/job/master/) console.
2. Create a new task definition version ([with AWS console](https://us-west-2.console.aws.amazon.com/ecs/home?region=us-west-2#/taskDefinitions/statsd-proxy/status/ACTIVE) is fine) pointing at the new image hash
3. [Update the service](https://us-west-2.console.aws.amazon.com/ecs/home?region=us-west-2#/clusters/statsd-proxy/services/statsd-proxy/details) definition to point at the new revision.
4. Monitor metrics in the [Voncount dashboard](https://grafana.xarth.tv/d/rmAtxD9Wz/metrics-pipeline-voncount?orgId=1&refresh=10s). Note that it may take as much as 8-10 minutes for new instances to be considered healthy by the NLB.

(It's possible we will make shell scripts or tools so this is even simpler in the future)
