package observe

import (
	"go.uber.org/zap"
	"go.uber.org/zap/zapcore"

	"code.justin.tv/edge/go-statsd-proxy/internal/build"
)

// bc aliases code.justin.tv/edge/go-statsd-proxy/internal/build.Context so that
// the implementation of the zap.ObjectMarshaler interface can be encapsulated in this package.
type bc build.Context

// MarshalLogObject implements the zapcore.ObjectMarshaler interface.
func (c bc) MarshalLogObject(enc zapcore.ObjectEncoder) error {
	enc.AddString("commit", c.Commit)
	enc.AddString("date", c.Date)
	enc.AddString("version", c.Version)

	return nil
}

func buildContext(ctx build.Context) zap.Field {
	return zap.Object("build", bc(ctx))
}
