package observe

import (
	"go.uber.org/zap"
	"go.uber.org/zap/zapcore"

	identifier "code.justin.tv/amzn/TwitchProcessIdentifier"
)

// pid aliases the ProcessIdentifier so that we can
type pid identifier.ProcessIdentifier

// MarshalLogObject implements the zapcore.ObjectMarshaler interface.
func (p pid) MarshalLogObject(enc zapcore.ObjectEncoder) error {
	enc.AddString("service", p.Service)
	enc.AddString("region", p.Region)
	enc.AddString("stage", p.Stage)
	enc.AddString("substage", p.Substage)
	enc.AddString("version", p.Version)
	enc.AddString("machine", p.Machine)
	enc.AddString("launchID", p.LaunchID)
	return nil
}

func processID(p identifier.ProcessIdentifier) zap.Field {
	return zap.Object("pid", pid(p))
}
