package proxy

type Observer interface {
	Increment(metric string, value int64)
	Error(msg string, err error, kv ...interface{})
}

// NoopObserver does nothing but implement the Observer interface.
type NoopObserver struct{}

func (NoopObserver) Increment(string, int64)             {}
func (NoopObserver) Error(string, error, ...interface{}) {}

var _ Observer = NoopObserver{}
