variable "name" {
  type        = string
  default     = "statsd-proxy"
  description = "The name or name prefix given to the resources managed by this module."
}

variable "environment" {
  type        = string
  description = "The logical environment this application belongs to (i.e. production)."
}

variable "udp_port" {
  type        = number
  default     = 8125
  description = "The UDP port which components of this module accept external traffic."
}

variable "tcp_port" {
  type        = number
  default     = 8080
  description = "The TCP port which the load balancer uses to health check the target task."
}

variable "vpc_id" {
  type        = string
  description = "The identifier of the VPC in which to create the target group."
}

variable "vpc_security_group_ids" {
  type        = list(string)
  description = "A list of security group IDs to associate with."
}

variable "subnet_ids" {
  type        = list(string)
  description = "A list of subnet IDs to attach to the LB."
}

variable "deregistration_seconds" {
  type        = number
  default     = 80
  description = "The number of seconds to wait before changing the state of a deregistering target from draining to unused."
}

variable "asg_instances" {
  type = object({
    type    = string
    desired = number
    max     = number
  })
  description = "The desired and maximum amount of EC2 instances to run in the autoscaling group, and their instance type."
}

variable "log_retention_days" {
  type        = number
  default     = 30
  description = "The number of days to retain application logs in CloudWatch."
}

variable "image_tag" {
  type        = string
  default     = "bootstrap"
  description = "The tag of the ECR image to use to run ECS tasks (e.g. 'deadb33f' or 'latest')."
}

variable "max_images" {
  type        = number
  default     = 20
  description = "Controls the maximum amount of images to keep in ECR for this application."
}

variable "reservation" {
  type = object({
    memory_mib = number
    cpu_units  = number
  })
  description = "The amount of memory (in mebibytes) and CPU units (1024 units = 1 vCPU) to reserve for each task."
}

variable "addresses" {
  type        = list(string)
  description = "A list of statsite ip:port addresses to forward UDP traffic to."
  default     = []
}

variable "hash_algorithm" {
  type        = string
  default     = "sha1"
  description = "Which algorithm to use for hashing metric keys. Possible values are 'fnv1a' and 'sha1'."
}

variable "num_forwarders" {
  type        = number
  default     = 16
  description = "The number of UDP forwarders to use in each application task."
}

variable "ulimit" {
  type        = number
  default     = 32768
  description = "The number of open files to allow within the container."
}

variable "stats_cluster_arn" {
  type        = string
  description = "The ECS cluster to which stats are sent"
}

variable "stats_cluster_name" {
  type        = string
  description = "The ECS cluster to which stats are sent"
}

variable "stats_service_name" {
  type        = string
  default     = "statsite"
  description = "The service name within the ECS cluster"
}

variable "pagerduty_sns_topic_arns" {
  type        = list(string)
  description = "A list of SNS topic ARNs that has a pagerduty integration subscribed to it."
}
