TIME_ZONE = 'US/Pacific'

SECRET_KEY='graphiteisawesome'

LOG_RENDERING_PERFORMANCE = True
LOG_CACHE_PERFORMANCE = True

STANDARD_DIRS = [] # No local DATA_DIRS since this is a local-only web box

DATABASES = {
    'default': {
        'ENGINE': 'django.db.backends.sqlite3',
        'NAME': '/opt/graphite/storage/graphite.db',
        'USER': '',
        'PASSWORD': '',
        'HOST': '',
        'PORT': ''
    }
}

def get_cluster_servers():
    out = []
    with open('/etc/hosts') as f:
        for line in f:
            ip_name = line.split()
            if len(ip_name) != 2:
                continue
            if ip_name[1].startswith("go_carbon"):
                out.append("{}:8080".format(ip_name[0]))
    return out

CLUSTER_SERVERS = get_cluster_servers()

CARBONLINK_HOSTS = []

REMOTE_RETRY_DELAY = 0 # retry failed go-carbon node immediately

MEMCACHE_HOSTS = []
DEFAULT_CACHE_DURATION = 50
