#!/bin/bash
set -e -x

build_name=haproxy
major_version=2
minor_version=2
maint_version=9

case ${DISTRO_CODENAME} in
    'bionic') LIBSSL='libssl1.1'
	    ;;
    'xenial') LIBSSL='libssl1.0.0'
	    ;;
esac

: ${ITERATION:="0"}
version=${major_version}.${minor_version}.${maint_version}
destdir="/tmp/$build_name/root"

desc="fast and reliable load balancing reverse proxy"

make_args="TARGET=linux-glibc USE_PCRE=1 USE_TFO=1 USE_OPENSSL=1 USE_ZLIB=1 USE_SYSTEMD=1 USE_NS=1"

rm -rf /tmp/$build_name/
mkdir /tmp/$build_name/

cd /tmp/$build_name/
wget http://haproxy.1wt.eu/download/${major_version}.${minor_version}/src/haproxy-${version}.tar.gz
tar -zxvf haproxy-${version}.tar.gz

cd /tmp/$build_name/haproxy-${version}
make ${make_args} -j
make DESTDIR=${destdir} ${make_args} install-man install-bin
rm -f ${destdir}/etc/haproxy/haproxy.cfg ${destdir}/etc/sysconfig/haproxy

mkdir -p "/tmp/${OUTPUT_DIR}"

cd "/tmp/${OUTPUT_DIR}"

if [ "${BUILD_TYPE}" == "rpm" ]; then
    [ "${DISTRO_NAME}" == "centos" ] && . /opt/rh/rh-ruby23/enable
    mkdir -p ${destdir}/usr/lib/systemd/system
    cp /tmp/haproxy.service ${destdir}/usr/lib/systemd/system
    fpm \
        -s dir \
        -t ${BUILD_TYPE} \
        --name "${build_name}" \
        --version "${version}" \
        --iteration "${ITERATION}${DISTRO_CODENAME}" \
        -C "${destdir}" \
        --depends glibc \
        --depends pcre \
        --depends zlib \
        --depends openssl-libs \
        --depends systemd-libs \
        --provides haproxy \
        --url http://www.haproxy.org/ \
        --description "${desc}" \
        --vendor "${VENDOR}" \
        --maintainer None
else
    fpm \
        -s dir \
        -t ${BUILD_TYPE} \
        --name "${build_name}" \
        --version "${version}" \
        --iteration "${ITERATION}${DISTRO_CODENAME}" \
        -C "${destdir}" \
        --depends libc6 \
        --depends ${LIBSSL} \
        --depends libpcre3 \
        --depends libsystemd0 \
        --depends zlib1g \
        --provides haproxy \
        --url http://www.haproxy.org/ \
        --description "${desc}" \
        --vendor "${VENDOR}" \
        --maintainer None
fi

ls -l
cd /tmp
tar -cvf "/tmp/${OUTPUT_DIR}.tar" "${OUTPUT_DIR}"
