#!/bin/bash
set -e -x

if [ "${DISTRO_NAME}" == "centos" ]
then
  yum install -y centos-release-scl-rh
  yum --enablerepo=centos-sclo-rh -y install rh-ruby23 rh-ruby23-ruby-devel
  . /opt/rh/rh-ruby23/enable
fi

if [ "${DISTRO_NAME}" == "amazonlinux" ]
then
  amazon-linux-extras install ruby2.4
fi

if [ "${BUILD_TYPE}" == "rpm" ]
then
  yum install -y \
	  pcre-devel \
	  make \
	  gcc \
	  perl \
	  pcre-devel \
	  zlib-devel \
	  openssl-devel \
	  systemd-devel \
	  ruby-devel \
	  wget \
	  rpm-build \
      git
  gem install --no-rdoc --no-ri -v 1.12.2 ffi
else
  echo "
  deb [arch=amd64] http://package-repo.live-video.a2z.com/ubuntu/ ${DISTRO_CODENAME} main restricted universe multiverse
  deb [arch=amd64] http://package-repo.live-video.a2z.com/ubuntu/ ${DISTRO_CODENAME}-updates main restricted universe multiverse
  " > /etc/apt/sources.list

  apt-get update
  apt-get install -y apt-utils
  apt-get install -y build-essential devscripts debhelper ruby-dev wget \
                     libssl-dev libpcre3-dev zlib1g-dev libsystemd-dev git-core
fi
  gem install --no-rdoc --no-ri fpm
