# Overview

This repository contains service that will retrieve Infoblox SNMP metrics, will select subset of those and push to the cloudwatch.

# How this works

SNMP metrics are retrieved using ```snmpbulkwalk``` command. Data decoding is done using MIBs downloaded from the
Infoblox appliance. Metrics are retrieved using ```/opt/twitch/infoblox-snmp-collector/get-stats.sh``` script that is
run every minute via cron.  This script uses ```*.sh``` plugins from the
```/opt/twitch/infoblox-snmp-collector/plugins``` directory to process retrieved data. Each plugin has corresponding
conf file, which is basically patterns, that should be filtered from the data retrieved via ```snmpbulkwalk```.
Multiple plugins are needed because unfortunately it is not possible to convert SNMP data into graphite line protocol in
a unified way.  Each metrics retrieval job uses lock of its own so long running jobs are not blocking fast jobs.

Metrics are published to the cloudwatch every minute. Since for certain instances metrics retrieval takes more than a
minute previous value will be pushed. If data is older than 15 minutes metrics will not be pushed.

# Cloudwatch

All metrics can be found in the us-west-2 region in the ```Infoblox``` namespace.

# Building and deployment

Infoblox-snmp-collector is deployed via debian package. Packge can be built by running ```build.sh``` script from the
repository. Please note that build uses packer so you nee to have docker installed. Repository has web hooks enabled so
any push to the repository initiates jenkins job that builds a package. Packages built in the non master branch are
pushed to the testing repository, builds on the master branch upload packages to the production repository. Package is
installed automatically by
[terraform](https://git.xarth.tv/video-coreservices/tf-io-infoblox-snmp-collector).
