#!/bin/bash

set -ue

PKG_DIR=/opt/twitch/infoblox-snmp-collector
VENV_DIR=$PKG_DIR/venv
SCRIPT_DIR=$(cd $(dirname $0) && pwd)
PACKER_VERSION=1.6.3
PACKER=${SCRIPT_DIR}/packer

deb_name=${1:-}

[ -z "$deb_name" ] && {
    cd $SCRIPT_DIR
    until [ -x $PACKER ] && [ "$($PACKER --version)" = "$PACKER_VERSION" ]; do
        wget -cqO /tmp/packer_${PACKER_VERSION}_linux_amd64.zip "https://releases.hashicorp.com/packer/${PACKER_VERSION}/packer_${PACKER_VERSION}_linux_amd64.zip"
        unzip /tmp/packer_${PACKER_VERSION}_linux_amd64.zip
    done
    . <(grep -E "^(Package|Version|Architecture):" root/DEBIAN/control |sed -e 's/: \(.*\)/="\1"/')
    $PACKER build -var deb_name=${Package}_${Version}_${Architecture}.deb -color=false packer.json
    exit
}

apt-get update && apt-get install -y wget python3 python3-distutils
python3 <(wget -qO- https://bootstrap.pypa.io/get-pip.py)
pip install virtualenv
virtualenv -p python3 $VENV_DIR
. $VENV_DIR/bin/activate
pip install boto3
build_dir=$(mktemp -d)
cp -r $SCRIPT_DIR/root/* $build_dir/
chmod -R go-w $build_dir/
mv $VENV_DIR $build_dir/$VENV_DIR
dpkg-deb -b $build_dir $SCRIPT_DIR/$deb_name
