#!/bin/bash

set -u

export MAX_DATA_DELAY=900
export INFOBLOX_IP="10.27.40.25 10.37.12.25 10.31.12.25"
export DATA_FILE_FMT="/tmp/infoblox-snmp-collector.%s.data"
export PID_FILE_FMT="/tmp/infoblox-snmp-%s.%s.pid"

script_dir="$(dirname $0)"
. $script_dir/venv/bin/activate || exit

get_lock() {
    local pid PID_LIST=$1
    while true; do
        while read pid; do
            kill -0 $pid || continue
            [ "$pid" != "$BASHPID" ] && return 1
            echo $BASHPID >$PID_LIST.new && mv $PID_LIST.new $PID_LIST && return 0
        done < $PID_LIST
        echo $BASHPID >>$PID_LIST
    done
}

collect_metrics() {
    local ip=$1
    local data_file=$(printf "$DATA_FILE_FMT" $ip)
    local pid_file=$(printf "$PID_FILE_FMT" collector $ip)
    local start=$(date +%s)

    get_lock $pid_file 2>/dev/null || return
    echo "$(date) snmpbulkwalk for $ip started" >&2
    snmpbulkwalk -M +${script_dir}/mibs/ -v3 -u jtv -m all $ip .1.3.6.1.4.1.7779 >$data_file.all
    for plugin in $script_dir/plugins/*.sh; do
        $plugin $data_file.all
    done >$data_file.new
    mv $data_file.new $data_file
    echo "$(date) snmpbulkwalk for $ip finished in $(( $(date +%s) - start))" >&2
}

publish_cloudwatch_metrics() {
    local ip=$1
    local data_file=$(printf "$DATA_FILE_FMT" $ip)
    local pid_file=$(printf "$PID_FILE_FMT" cloudwatch-publisher $ip)
    local start=$(date +%s)

    get_lock $pid_file 2>/dev/null || return
    [ -s "$data_file" ] || return
    (( start - $(stat -c %Y "$data_file") > MAX_DATA_DELAY )) && return
    echo "$(date) publish_cloudwatch_metrics for $ip started" >&2
    $script_dir/cloudwatch-helper.py $data_file $ip
    echo "$(date) publish_cloudwatch_metrics for $ip finished in $(( $(date +%s) - start))" >&2
}

echo "$(date) $0 started" >&2
for ip in $INFOBLOX_IP; do
    collect_metrics $ip &
    publish_cloudwatch_metrics $ip &
done
wait
echo "$(date) $0 finished" >&2
