# configure hardware raid arrays or jbod
# no config optimizations are being made there
#  * ssd recommended settings
#  * disable or enable diskcache
#  * disable or enable ncq 
#  * configure directio vs cacheio
#  * write back/though when bbu is bad or not present
   
FS_LAYOUT=swraid
if lspci | grep -i megaraid > /dev/null 2>&1
then
  # set layout to none sw raid
  FS_LAYOUT=noraid

  # delete all logical volumes on all controllers
  /bin/megacli cfglddel lall aall

  # get first enclosure id.
  ENC_ID=$(/bin/megacli encinfo aall | grep "Device ID" | head -1 | tr -d " " | cut -f2 -d:)

  # create r1
  # assuming slot 0 and 1 are populated.
  # assuming a0 for the controller
  /bin/megacli cfgldadd r1 [${ENC_ID}:0, ${ENC_ID}:1] a0

  # jbod mode (eg no hardware raid)
  # assuming a0 for the controller
  /bin/megacli adpsetprop enablejbod 1 a0

  # megaraid needs sometime before logical drive is available
  sleep 10

fi
