job {
    name "vidcs-ipmi-build"
    description("build and deploy the twitch_ipmi pypi module")
    using 'TEMPLATE-autobuild'
    scm {
        git {
            remote {
                github 'video-coreservices/ipmi', 'ssh', 'git.xarth.tv'
                credentials 'git-aws-read-key'
            }
            clean true
            branches 'origin/*'
        }
    }

    wrappers{
        credentialsBinding {
            string('dtatoolsdeploy', 'dtatoolsdeploy')
            string('dta_tools_deploy', 'dta_tools_deploy')
        }
    }

    steps {
        conditionalSteps {
            condition {
                stringsMatch('$GIT_BRANCH', 'origin/master', true)
            }
            steps {
                shell """
                    sed -i "s/twitch_ipmi-staging/twitch_ipmi/" setup.py
                """
            }
        }

        shell """
            sed -i "s/\\.000/.\${BUILD_NUMBER}/" setup.py
        """
        uploadPyPi '.'
    }
}

