#!groovy
package tv.justin.vidcs;

def readDeb(package_file) {
	package_name = package_file.replaceAll(/\.deb$/, "")
	version = sh(returnStdout: true, script: "dpkg-deb --showformat '\${Version}' -W ${package_file}")
	arch = sh(returnStdout: true, script: "dpkg-deb --showformat '\${Architecture}' -W ${package_file}")

	echo arch
	echo version
}

def readRPM(package_file) {
}

def Upload(package_file) {
	package_type = determinePackageType(package_file)
	if (package_type == "deb") {
		readDeb(package_file)
	} else if (package_type == "rpm") {
		readRPM(package_file)
	}
}

def determinePackageType(package_file) {
	file_output = sh(returnStdout: true, script: "file ${package_file}")
	is_rpm = (file_output ==~ /\ RPM\ /)
	is_deb = (file_output ==~ /Debian/)
	if (is_rpm) {
		return "rpm"
	}

	if (is_deb) {
		return "deb"
	}
}

/*
'VERSION=`dpkg-deb -I ' + debPath + ' | grep "^ Version: " | cut -d" " -f3`; ' +
'ARCH=`dpkg-deb -I ' + debPath + ' | grep "^ Architecture: " | cut -d" " -f3`; ' +
'FILTR=$(echo ' + debNameStub +' | cut -c 1); ' +
'curl --fail -udta_tools:$dta_tools_deploy -XPUT "https://packages.internal.justin.tv/artifactory/' + repo + '/pool/main/${FILTR}/' + debNameStub + '/' + debNameStub + '_${VERSION}_${ARCH}.deb;deb.distribution=' + rel +';deb.architecture=$ARCH;deb.version=$VERSION;deb.component=main" -T ' + debPath
*/
