#!groovy
package tv.justin.vidcs;

def Update(version = "1.2.4") {
	stage("Update Packer") {
		url = "https://releases.hashicorp.com/packer/${version}"
		filename = "packer_${version}_linux_amd64.zip"

		sh "mkdir -p packer"
		echo "Installing Packer ${version}..."
		dir("packer") {
			// Get Packer zip file
			sh "wget -q \"${url}/${filename}\""
			echo "Checking SHASUMS..."
			sh "curl -s \"${url}/packer_${version}_SHA256SUMS\" | grep ${filename} | sha256sum -c"
			sh "unzip -o -q ${filename}"
			sh "rm -f ${filename}"
		}
		echo "Installed packer-${version} to ./packer"
	}
	return "${pwd()}/packer"
}
