
# Kontron lambda
Lambda that relies on the [buildsheet-service](https://git.xarth.tv/video-tools/buildsheet-service/) and [Infoblox](https://gm-infoblox.twitch.tv) to create Fixedaddress records for Kontron BMC:s

## API endpoints
|Endpoint|Function|Comment|
|---|---|---|
|/|Hello World|Test that lambda is callable|
|/auth|Authentication test|Debug: Verify that API Key is usable|
|/credscheck|Credentials check|Debug: Verify that Lambda can fetch SSM credentials|
|/list/\<site\>/\<rack\>/\<unit\>|List entries for site+rack+unit|Debug: Generate and return entries for site+rack+unit, returns existing entries from Infoblox if found|
|/exist/\<site\>/\<rack\>/\<unit\>|Check existence for site+rack+unit|Debug: Check existence|
|/create/\<site\>/\<rack\>/\<unit\>|Create entries for site+rack+unit|Generate and push entries for site+rack+unit to Infoblox|
|/replace/\<site\>/\<rack\>/\<unit\>/\<sled\>|Replace a sled|Updates the mac address on a fixedaddress for when a single sled is replaced|
|/restart|Issue servicerestart to Infoblox|Issues a safe servicerestart to Infoblox, can't run if other users have changes pending|

If records for a given site+rack+unit combination already exists, /list will return the current objects from Infoblox as part of the output.
The /create endpoint will change existing "ACTIVE" leases into "STATIC" ones to prevent duplicate leases/running out of assignable IP space.

Note that after triggering creation via /create endpoint you will need to manually restart services in Infoblox.

### API key usage
Supply the API key in the X-Api-Key header field like:
```curl -X GET -H "X-Api-Key: <API_KEY_HERE>" https://<URL>/api/auth```

### Extensible Attributes
Via the use of Extensible Attributes (Site, RackNumber, Chassis), you should easily be able to fetch all the records for a given Site/Rack/Unit combination via either the /list endpoint OR via infoblox wapi directly, the query for that would look like:
```curl -k https://<INFOBLOX_URL>/wapi/v2.5/fixedaddress?*Site=<SITE>&*RackNumber=<RACK>&*Chassis=<RACKUNIT>&_return_fields=ipv4addr,mac,ddns_hostname,extattrs```

### Deployment
The lambda is built with AWS Lambda framework called [Chalice](https://github.com/aws/chalice).

Different stages/deployments are defined in .chalice/config.json

To deploy/redeploy a stage: ```chalice deploy --stage <stagename>```
(Note that on initial deployment this will not create/associate any usage plans or api keys with the apigw.)
If it bails at upload due to credentials (I get this frequently), just upload the .zip from .chalice/deployments/ using the "upload a .zip" action on the AWS Lambda page.
