#!/bin/bash
set -e -x -u

apt-get update
apt-get install -y build-essential devscripts debhelper git \
  checkinstall libpcre3-dev pkg-config libldap2-dev curl autoconf \
  flex bison libncurses5-dev vim tree ruby-dev linux-base wget


name=ladvd
dir="${BUILD_ROOT}/${name}"
source_url_base="https://launchpad.net/ubuntu/+archive/primary/+sourcefiles/ladvd/1.1.2-1"
rm -rf ${dir}
mkdir -p ${dir}

cd ${dir}

apt-get install -y dh-systemd libtool libbsd-dev libpcap-dev libcap-ng-dev libevent-dev libmnl-dev libteam-dev libpci-dev dh-autoreconf

wget \
${source_url_base}/ladvd_1.1.2-1.dsc \
${source_url_base}/ladvd_1.1.2-1.debian.tar.xz \
${source_url_base}/ladvd_1.1.2.orig.tar.xz

dpkg-source -x *.dsc

cd  */
# lower to xenial's debhelper version.
sed -i 's/9.20160403~/9.20160115ubuntu3/g' debian/control
debuild -b -us -uc

ls -l ${dir}
