## lease to fixedaddress
Pass in the following as args: pop, rack, rackunit, sled-identifier, mac

Example: $ python lease_to_fixedaddress.py sjc02 r404 13 s1 00:a0:a5:cc:b9:b6

Upon posting the fixedaddress object to Infoblox, an error will be returned if a given mac is already in use by another fixedaddress object. I opted to not catch these errors but instead just return them as the final output.

!!! The only line that will cause changes to Infoblox is the call to post_infoblox_fixedaddress
So for testruns (simply printing the object, I would comment out that call at line 242)

The script will print the object during a run, a proper object should look similar to the below json structure.
(Note that the ipv4addr value may also be "func:nextavailableip:dhcrangeStart-dhcprangeEnd"
which means it will use the Infoblox API function call to fetch an ip from the dhcprange).

    {
        "comment": "created by script",
        "ddns_hostname": "mgmt-r999.ru01.s1",
        "enable_ddns": true,
        "extattrs": {
            "Chassis": {
                "value": "1"
            },
            "RackNumber": {
                "value": "r999"
            },
            "Site": {
                "value": "pop01"
            }
        },
        "ipv4addr": "1.2.3.4",
        "mac": "00:12:34:56:78:90"
    }

The final output of a successful run is the objects "_ref" value in Infoblox, example:

$ fixedaddress/ABCDEFGABCDEFGABCDEFGABCDEFGABCDEFG:1.2.3.4/default

This can be used to easily delete a created object via curl like:

$ curl -X DELETE -k -u adamnybe https://gm-infoblox.twitch.tv/wapi/v2.5/fixedaddress/ABCDEFGABCDEFGABCDEFGABCDEFGABCDEFG:1.2.3.4/default



Note that Infoblox services needs to be restarted for changes to happen, I would restart services inbetween every new chassis/rackunit.
