#!/bin/bash

set -e

DIST=$(grep CODENAME /etc/lsb-release | cut -f 2 -d =)

case $DIST in
  xenial)
    LIBTEAM_VER=1.23-1
    ;;
  bionic)
    LIBTEAM_VER=1.26-1
    ;;
esac

# download and extract libteam sources
apt-get source --download-only libteam=${LIBTEAM_VER}
tar Jfx "libteam_${LIBTEAM_VER}.debian.tar.xz" -C libteam
cd libteam

# patch the changelog with our patch
for patch in /build/patches/*.patch; do
  patch -p1 < "${patch}"
done

dpkg-buildpackage -uc -b
