#!/bin/bash
set -ex

SHA=87cdebbcad6f4e16ba711227cbbbd70039f88752

sed -i "s/\(archive\|security\).ubuntu.com/${DISTRO_REPO_HOSTNAME}/g" /etc/apt/sources.list
apt-get update
apt-get upgrade -y
apt-get install --no-install-recommends -y squashfs-tools genisoimage wget ca-certificates gnupg make apt-cacher-ng python3 python3-pip python3-setuptools
pip3 install --index-url='https://pypi.internal.justin.tv/simple/' video-pyemf boto3

cd /tmp
wget https://salsa.debian.org/installer-team/debootstrap/-/archive/$SHA/debootstrap-$SHA.tar.gz
tar -xf debootstrap-$SHA.tar.gz
rm $_
cd debootstrap-$SHA/
make install
cd ..
rm -rf  debootstrap-$SHA/
for codename in xenial bionic; do
    debootstrap --arch amd64 --verbose --include=gnupg,locales --variant=minbase $codename /image_root_${codename} http://${DISTRO_REPO_HOSTNAME}/ubuntu
    rm -f /image_root_${codename}/etc/resolv.conf
    tar czf /image_root_${codename}.tgz /image_root_${codename}
    rm -rf /image_root_${codename}
done
rm -rf /var/lib/apt/lists/*
