# Overview

This repository holds service that will run serverspec tests against [netboot image](https://git-aws.internal.justin.tv/video-coreservices/transcode_ubuntu_image).

# How this works

This service was created because we can't pxeboot image we build on the jenkins slaves to verify that image works ok and run tests.
After image is built artifacts (kernel, initrd and squashfs) are uploaded to s3. Subset of the workspace necessary to boot the image and run tests is archived and also uploaded s3.
Jenkins pushes information (test\_url and run\_id) necessary to run test to the sqs queue. Netboot-validator service (that can run on multiple machines) retrieves this information and start test run.

## What happens on the netboot-validator service after retrieving message from sqs:

- Test run directory is created
- Archive prepared by jenkins is unpacked into the test run directory
- Temporary ssh key pair is generated and ssh config is created to use generated private key
- Post-boot script is created that will create user toor and will add public ssh key to the /home/toor/.ssh/authorized\_keys in the image to allow test run over ssh
- boot.ipxe file is generated using artifacts urls provided by jenkins
- qemu starts vm, that boots off the netboot image
- Serverspec test are run
- qemu vm is stopped
- Cleanup is done and old test run results are purged

Logic above is implemented in the [script](root/opt/twitch/bin/netboot-validator.sh)

## What happens on the jenkins side:

- Jenkins job will be polling sqs queue with the name based on the run\_id from the previous step
- Netboot-validator will send back run\_url where test run results should be expected
- Jenkins job will poll netboot-validator service every 10 seconds checking for serverspec test run status. If test run will not complete in 10 minutes Jenkins job will consider test run as failed and will proceed.
- Jenkins job will download shell.log from the run\_url.
- If serverspec run will have no failures and will return 0 exit code test run will be considered successful.

# Building netboot-validator debian package

Netboot-validator service is installed via debian package, that is build via makefile. Just run ```make``` or ```make in_packer``` and you will have debian package in the root directory of the repository.
Netboot-validator jenkins job will build debian package using ```make in_packer``` and will upload resulting package to artifactory.

# Deployment

Service is deployed automatically as part of the [terraform](https://git.xarth.tv/video-coreservices/tf-io-netboot-validator).
