#!/usr/bin/env python3

import datetime
import logging

import pyemf
from pyemf import Dimension, Metric

if __name__ == "__main__":
    parser = pyemf.get_argparser(namespace='NetbootBuild', log_group='NetbootBuild')
    parser.add_argument('-d', '--distro', type=str, default='precise',
                        help='The distro dimension for this metric')
    parser.add_argument('-e', '--environment', type=str, default='development',
                        help='The environment dimension for this metric')
    args = parser.parse_args()

    if args.debug:
        level = logging.DEBUG
    else:
        level = logging.INFO
    logging.basicConfig(level=level, format='%(message)s')


    dimensions = [
        [
            Dimension('distro', args.distro),
            Dimension('environment', args.environment),
        ],
        [
            Dimension('distro', args.distro),
        ],
        [
            Dimension('environment', args.environment),
        ],
    ]

    metrics = [Metric(args.metricname, args.value)]

    writer = pyemf.get_writer(args)
    writer.send_message(metrics=metrics, dimensions=dimensions)
