#!/bin/bash
set -x -e

case "${DISTRO_CODENAME}" in
    xenial) DRIVER_VERSION=( '2.11.29' '2.15.9' ) ;;
    bionic) DRIVER_VERSION=( '2.15.9' ) ;;
    focal) DRIVER_VERSION=( '2.15.9' ) ;;
    *) echo "Unsupported version ${DISTRO_CODENAME}" && exit 1 ;;
esac

TWITCH_VERSION='1'
. /tmp/source/scripts/kernels.sh

for driver_version in "${DRIVER_VERSION[@]}" ; do
    download_url="https://downloads.sourceforge.net/project/e1000/i40e%20stable/${driver_version}/i40e-${driver_version}.tar.gz"
    wget -qO- "${download_url}" | tar -zxf - -C /usr/src
    
	cat <<-EOF > "/usr/src/i40e-${driver_version}/dkms.conf"
	PACKAGE_NAME="i40e-dkms"
	PACKAGE_VERSION="${driver_version}-${TWITCH_VERSION}"
	BUILT_MODULE_NAME[0]="i40e"
	CLEAN="make -C src/ clean"
	BUILT_MODULE_LOCATION[0]=src/
	DEST_MODULE_LOCATION[0]="/kernel/drivers/net/ethernet/intel/i40e/"
	MAKE[0]="'make' -C src/ KSRC=/lib/modules/\${kernelver}/build CONFIG_MODULE_SIG=n"
	AUTOINSTALL="yes"
	REMAKE_INITRD="yes"
	EOF
    
    dkms add -m i40e -v "${driver_version}"
    
    for kernel in "${KERNELS[@]}" ; do
        dkms install -m i40e -v "${driver_version}" -k "${kernel}-generic"
        dkms mkdeb   -m i40e -v "${driver_version}" -k "${kernel}-generic" --source-only
        dkms mkbmdeb -m i40e -v "${driver_version}" -k "${kernel}-generic"
    done
    cp /var/lib/dkms/i40e/"${driver_version}"/deb/i40e-*.deb "${SOURCE_DEST}/ip-${DISTRO_CODENAME}-twitch/"
    cp /var/lib/dkms/i40e/"${driver_version}"/bmdeb/*.deb "${SOURCE_DEST}/ip-${DISTRO_CODENAME}-twitch/"
done

chown --reference "${SOURCE_DEST}" "${SOURCE_DEST}/ip-${DISTRO_CODENAME}-twitch/"
