#!/bin/bash
set -x -e
DRIVER_VERSION='5.3.3'
TWITCH_VERSION='1'

sudo apt-get install -y dkms

wget --content-disposition  "https://downloads.sourceforge.net/project/e1000/ixgbe%20stable/${DRIVER_VERSION}/ixgbe-${DRIVER_VERSION}.tar.gz"

sudo tar -zxf ixgbe-${DRIVER_VERSION}.tar.gz -C /usr/src/
rm ixgbe-${DRIVER_VERSION}.tar.gz

cat << EOF > /tmp/ixgbe.dkms.conf
PACKAGE_NAME="ixgbe-dkms"
PACKAGE_VERSION="${DRIVER_VERSION}-${TWITCH_VERSION}"
BUILT_MODULE_NAME[0]="ixgbe"
CLEAN="make -C src/ clean"
BUILT_MODULE_LOCATION[0]=src/
DEST_MODULE_LOCATION[0]="/kernel/drivers/net/ethernet/intel/ixgbe/"
MAKE[0]="'make' -C src/ KSRC=/lib/modules/\${kernelver}/build CONFIG_MODULE_SIG=n"
AUTOINSTALL="yes"
REMAKE_INITRD="yes"
EOF
sudo cp /tmp/ixgbe.dkms.conf /usr/src/ixgbe-${DRIVER_VERSION}/dkms.conf

if [ -d "/var/lib/dkms/ixgbe/${DRIVER_VERSION}" ]
then
  sudo dkms remove  ixgbe/${DRIVER_VERSION} --all
fi

sudo dkms add -m ixgbe -v ${DRIVER_VERSION}

#for i in /lib/modules/*
#do
#    sudo dkms install ixgbe/${DRIVER_VERSION} -k ${i##*/}
#done

sudo dkms mkdeb ixgbe/${DRIVER_VERSION} --source-only

cp /var/lib/dkms/ixgbe/${DRIVER_VERSION}/deb/ixgbe-dkms_${DRIVER_VERSION}_all.deb /vagrant/output

sudo dkms remove ixgbe/${DRIVER_VERSION} --all
