#!/bin/bash
set -x -e
# found at http://www.mellanox.com/page/software_overview_eth
case "${DISTRO_CODENAME}" in
    xenial)
        VERSION_LONG=( )
        VERSION_SHORT=( )
        ;;
    bionic)
        VERSION_LONG=( '5.2-1.0.4.0' )
        VERSION_SHORT=( '5.2' )
        ;;
    focal)
        VERSION_LONG=( '5.3-1.0.0.1' )
        VERSION_SHORT=( '5.3' )
        ;;
    *) echo "Unsupported version ${DISTRO_CODENAME}" && exit 1 ;;
esac

. /tmp/source/scripts/kernels.sh

for i in "${!VERSION_LONG[@]}"
do
    download_url="http://content.mellanox.com/ofed/MLNX_EN-${VERSION_LONG[i]}/mlnx-en-${VERSION_LONG[i]}-ubuntu${DISTRO_RELVER}-x86_64.tgz"
    wget -qO- "${download_url}" | tar -zxf -
    
    cd "mlnx-en-${VERSION_LONG[i]}-ubuntu${DISTRO_RELVER}-x86_64/DEBS_ETH"
    
    dpkg --unpack  mlnx-en-dkms_*.deb mlnx-en-utils_*.deb 
    
    dkms status
    
    for kernel in "${KERNELS[@]}" ; do
      dkms install -m mlnx-en -v "${VERSION_SHORT[i]}" -k "${kernel}-generic"
      dkms mkbmdeb -m mlnx-en -v "${VERSION_SHORT[i]}" -k "${kernel}-generic"
    done

    cp mlnx-en-dkms_*.deb mlnx-en-utils_*.deb "${SOURCE_DEST}/ip-${DISTRO_CODENAME}-twitch/"
    cp /var/lib/dkms/mlnx-en/"${VERSION_SHORT[i]}"/bmdeb/*.deb "${SOURCE_DEST}/ip-${DISTRO_CODENAME}-twitch/"
    chown --reference "${SOURCE_DEST}" "${SOURCE_DEST}/ip-${DISTRO_CODENAME}-twitch/"

done
