#!/bin/bash
set -ex

. /tmp/source/scripts/kernels.sh

mkdir -p "${SOURCE_DEST}/ip-${DISTRO_CODENAME}-twitch/"
chown --reference "${SOURCE_DEST}" "${SOURCE_DEST}/ip-${DISTRO_CODENAME}-twitch/"
#sed -i 's/archive.ubuntu.com/package-repo.internal.justin.tv/g' /etc/apt/*.list
sed -i 's/^deb-src/#deb-src/g' /etc/apt/*.list
apt-get update
apt-get install -y build-essential debhelper dkms wget pciutils

case "${DISTRO_CODENAME}" in
    xenial)
        wget http://package-repo.live-video.a2z.com/ubuntu/pool/main/d/dkms/dkms_2.3-3ubuntu9.7_all.deb
        dpkg -i dkms_2.3-3ubuntu9.7_all.deb
	;;
esac

for kernel_version in "${KERNELS[@]}" ; do
    apt-get install -y "linux-headers-${kernel_version}-generic" "linux-headers-${kernel_version}"
done
