#!/bin/bash
set -eux -o pipefail

cd "${SCRATCH_ROOT}/nginx"
destdir="${BUILD_ROOT}"

./configure --with-compat \
            --with-http_ssl_module \
            --with-http_v2_module \
            --with-http_flv_module \
            --with-http_dav_module \
            --with-file-aio \
            --with-http_gzip_static_module \
            --with-http_mp4_module \
            --with-http_stub_status_module \
            --with-http_sub_module \
            --with-http_auth_request_module \
            --add-dynamic-module=../ngx_http_bytes_filter_module-801de8ae9c0b \
            --add-dynamic-module=../nginx_upload_module-2.255 \
            --add-dynamic-module=../ngx_http_consistent_hash \
            --add-dynamic-module=../graphite-nginx-module \
            --add-dynamic-module=../ngx_brotli \
            --add-dynamic-module=../ngx_upstream_jdomain

make -j
cat << EOF >> objs/Makefile
	cp /dev/null '\$(DESTDIR)/usr/local/nginx/logs/access.log'
	cp '\$(DESTDIR)/usr/local/nginx/conf/fastcgi_params.default' '\$(DESTDIR)/usr/local/nginx/conf/fastcgi_params'
	cp '\$(DESTDIR)/usr/local/nginx/conf/mime.types.default' '\$(DESTDIR)/usr/local/nginx/conf/mime.types'
EOF
# Remove nginx.conf from final build
perl -p -i -e 's/(.*test.*nginx\.conf.*)/# $1/g' objs/Makefile

# Necessary dirs
mkdir -p "${BUILD_ROOT}/usr/local/nginx/servers" \
mkdir -p "${BUILD_ROOT}/usr/local/nginx/ssl" \
         "${BUILD_ROOT}/var/log/nginx"

make DESTDIR="${destdir}" install
chown -R --reference=/src "/src/${OUTPUT_DIR}"
