#!/bin/bash
set -eu -o pipefail -x

mount -o rw,noatime,suid,dev,exec,remount "${SCRATCH_ROOT}"
cd "${SCRATCH_ROOT}"

URL="http://nginx.org/download/nginx-${PACKAGE_VERSION}.tar.gz"

wget -c "$URL"
gpg --import <(wget -O - http://nginx.org/keys/mdounin.key)
gpg --verify <(wget -O - "${URL}.asc") "nginx-${PACKAGE_VERSION}.tar.gz"

tar -zxvf "nginx-${PACKAGE_VERSION}.tar.gz"
mv "nginx-${PACKAGE_VERSION}" nginx

# What's this?
wget -c http://mdounin.ru/hg/ngx_http_bytes_filter_module/archive/801de8ae9c0b.tar.gz
tar -zxvf 801de8ae9c0b.tar.gz

# Modules stuff
git clone -b 2.255 https://github.com/vkholodkov/nginx-upload-module.git nginx_upload_module-2.255
git clone -b v2.1 https://github.com/mailru/graphite-nginx-module.git
git clone --recursive https://github.com/google/ngx_brotli.git
git clone https://github.com/wdaike/ngx_upstream_jdomain.git

# dynamic module support
git clone -b dynamic_module https://github.com/hnakamur/ngx_http_consistent_hash.git

#####
cd nginx
patch -p1 < ../graphite-nginx-module/graphite_module_v1_7_7.patch
