# Package Builder

[![Build Status](https://jenkins.internal.justin.tv/buildStatus/icon?job=video-coreservices/package-builder/master)](https://jenkins.internal.justin.tv/job/video-coreservices/job/package-builder/job/master/)

This is the main repo for the 'meta' Jenkins build job, which executes downstream builds.
Its made up of a single `Jenkinsfile`, which creates a standarized build pipeline.


### Overview


![overview diagram](docs/package-build-framework.svg)

`make` builds `fpm-helper` which simply wraps a json file which then runs `fpm` from its input. After any packages have been created, the artifacts are then uploaded to Artifactory.


The design intention is to have 1 master job with inputs that can build a number of package outputs following a standard convention:

  * The packages must end up in a folder named for the artifactory repo it should be uploaded to. For example: ./ip-xenial-twitch/somepackagename.deb, ./ip-vidcs-dev/someotherpackagename.rpm
    * See [Unbound](https://git.xarth.tv/video-coreservices/unbound) for a working example.
  * Downstream repo must use `make` with no arguments or targets to start building
  * To have a package built with `fpm-helper`, repo must to contain at least 1 `fpm.json` file in the repo.
    * Paths will be relative to this file
  * Versioning must be handled by the downstream repo.
