#!/bin/bash
# Usage: ./deploy_packages <package type> <arti config file> <component string flag> <repo folder label>
# Package type: Usually deb or rpm, whatever your package type is
# Arti config file: the variable name holding the necessary arti config file
# Component string flag (Optional, Only for deb): "-p" flag, it changes the default component value from "main" to your choice
# Repo folder label (Optional, Only for deb): usually "testing", can be whatever value you need

# write filepaths to array paths
paths=()
while IFS=  read -r -d $'\0'; do
    paths+=("$REPLY")
done < <(find . -name "*.$1" -print0)

# check that files were found
if [ ${#paths[@]} -eq 0 ]; then
    echo "No Packages matching *.$1 found"; exit 0
else
    echo "packages found: ${paths[*]}"
fi

# get parent folder names and construct arti command for every package found
for p in "${paths[@]}"; do
    parentnames=$(awk  -F/ '{print $--NF}' <<< "$p")
    # arti fails to automatically set deb.distribution attrib for anything
    # not xenial or bionic. Set deb.distribution with -o
    IFS='-' read -r -a array <<< "$p"
    distro=${array[1]}
    case $parentnames in
        "ip-${distro}-twitch")
            arti_extra_args="-o ${distro}"
        ;;
    esac
    arti_args="${arti_extra_args} -c $2 $1 -r $parentnames $3 $4 $p"
    echo "running arti ${arti_args}"
    # shellcheck disable=SC2086
    arti ${arti_args}
done
