# Apt-mirror Container Build Pipeline

This is the build pipeline for the apt-mirror container that is run to operate the package repository

## Testing
1. Make a branch
2. Make your changes
2. Increment the version number appropriately. See [Versioning](#versioning)
3. Push to your branch. Jenkins will build the image and push to the ECR repo in twitch-video-coreservices+package-repo-dev-us-west-2@amazon.com

## Pushing to Prod
1. Get your tested changes reviewed.
2. Once your PR is approved, merge to master. Jenkins will build the image and push to the ECR repos in twitch-video-coreservices+package-repo-prod-us-west-2@amazon.com and twitch-video-coreservices+package-repo-prod-us-east-2@amazon.com
3. Make sure you return to the tf-io-package-repo repository and update the version number in ecs.tf to ensure the new version gets used.


## Versioning
Version according to the [Semantic Versioning](https://semver.org/) guidelines.

Given a version number MAJOR.MINOR.PATCH, increment the:

1. MAJOR version when you make incompatible API changes,
1. MINOR version when you add functionality in a backwards compatible manner, and
1. PATCH version when you make backwards compatible bug fixes.
