#!/bin/bash

set -uex

ua attach "$UA_KEY_V1"

CREDS=$(awk '{print $4 ":" $6}' /etc/apt/auth.conf.d/90ubuntu-advantage)

cat <<EOF >> /opt/apt-mirror.production
# mirror ESM ubuntu-xenial-infra-security
deb https://$CREDS@esm.ubuntu.com/infra/ubuntu xenial-infra-security main

# mirror ESM ubuntu-xenial-infra-updates
deb https://$CREDS@esm.ubuntu.com/infra/ubuntu xenial-infra-updates main
EOF

/usr/bin/apt-mirror /opt/apt-mirror.production

# Cat logs to stdout to be picked up by cloudwatch
ua detach --assume-yes

cat /opt/var/*log*
