#!/bin/sh -e

## Anything in this file gets run AFTER the mirror has been run.
## Put your custom post mirror operations in here (like rsyncing the installer
## files and running clean.sh automatically)!

## Example of grabbing the extra installer files from Ubuntu (Note: rsync needs
## to be installed and in the path for this example to work correctly)

UBUNTU_HOST=us.archive.ubuntu.com

for dist in xenial-updates bionic-updates; do
  wget \
    --quiet \
    --no-parent \
    --recursive \
    --execute "robots=off" \
    --reject "index.html*,robots.txt*" \
    --no-host-directories \
    --cut-dirs 1 \
    --directory-prefix=/mnt/aptmirror/mirror/${UBUNTU_HOST}/ubuntu \
    --timestamping \
    http://${UBUNTU_HOST}/ubuntu/dists/${dist}/main/installer-amd64/current/images/netboot/ubuntu-installer
done
