#!/usr/bin/env bash

while [ $# -gt 0 ]; do
  case "$1" in
    -r=*)
      REPO_URI="${1#*=}"
      ;;
    *)
      printf "Error: Invalid argument\n"
      exit 1
  esac
  shift
done

if [ -z ${REPO_URI+x} ];
  then echo "Usage: $0 -r=REPO_URI"
  exit 1
fi

if docker build -t "${REPO_URI}" .; then
  echo
  echo "Build of ${REPO_URI} completed OK"
  echo

  # log build details to builds file
  echo "$(date) => ${REPO_URI}" >> builds

# The build exited with an error.
else
  echo "Building aptmirror failed!"
  exit 1

fi
