#!/bin/bash
set -xe

environment="${1:-staging}"

sha=$(git rev-parse --short HEAD)
today_date=$(date +'%Y%m%d%H%M%S')
declare -A s3_url=(
    [staging]=s3-reverse-proxy.us-east-2.staging.provisioner.live-video.a2z.com
    [production]=s3-reverse-proxy.us-west-2.prod.provisioner.live-video.a2z.com
)
url=${s3_url[$environment]}
read ip < <(dig +short $url)

cd output/

for file in $(find */ -type f); do
    aws s3 cp --no-progress --only-show-errors "${file}" "s3://provisioner-images-${environment}/jenkins/preseed_bootfiles/${today_date}-${sha}-${BUILD_ID}/${file}"
    name_url="http://${url}/jenkins/preseed_bootfiles/${today_date}-${sha}-${BUILD_ID}/${file}"
    ip_url="http://${ip}/jenkins/preseed_bootfiles/${today_date}-${sha}-${BUILD_ID}/${file}"
    echo "Avaliable at $name_url"
    case $ip_url in
        /initrd.xz) echo initrd=$ip_url ;;
        /linux) echo vmlinuz=$ip_url ;;
        /filesystem.squashfs) echo squashfs=$ip_url ;;
    esac >> artifact_urls
done
