#!/bin/bash
set -x -e -o pipefail

get_preseed_files () {
    UBUNTU_DIST=$1
    LSBDISTCODENAME=${UBUNTU_DIST%%-*}
    UBUNTU_RELEASE=$2
    INSTALL_TYPE=$3
    POINT_RELEASE=$4

    # download linux kernel and initrd
    mkdir -p /${OUTPUT_DIR}/${LSBDISTCODENAME}/${POINT_RELEASE}/
    echo 'Downloading kernel and initrd...'
    MIRROR_BASE="http://${MIRROR_HOST}/ubuntu/dists/${UBUNTU_DIST}/main/installer-amd64/${UBUNTU_RELEASE}/images/${INSTALL_TYPE}/ubuntu-installer/amd64"
    wget --progress=dot:giga -O /${OUTPUT_DIR}/${LSBDISTCODENAME}/${POINT_RELEASE}/linux ${MIRROR_BASE}/linux
    wget --progress=dot:giga -O /${OUTPUT_DIR}/${LSBDISTCODENAME}/${POINT_RELEASE}/initrd.gz ${MIRROR_BASE}/initrd.gz
    if wget -q --spider http://old-releases.ubuntu.com/releases/${LSBDISTCODENAME}/ubuntu-${POINT_RELEASE}-server-amd64.iso
    then
        wget --progress=dot:giga http://old-releases.ubuntu.com/releases/${LSBDISTCODENAME}/ubuntu-${POINT_RELEASE}-server-amd64.iso
    elif wget -q --spider https://releases.ubuntu.com/releases/${LSBDISTCODENAME}/ubuntu-${POINT_RELEASE}-live-server-amd64.iso
    then
	wget --progress=dot:giga https://releases.ubuntu.com/${POINT_RELEASE}/ubuntu-${POINT_RELEASE}-live-server-amd64.iso
    elif wget -q --spider https://releases.ubuntu.com/releases/${LSBDISTCODENAME}/ubuntu-${POINT_RELEASE}-server-amd64.iso
    then
	wget --progress=dot:giga https://releases.ubuntu.com/${POINT_RELEASE}/ubuntu-${POINT_RELEASE}-server-amd64.iso
    else
	echo Cannot find iso for ${UBUNTU_DIST} ${POINT_RELEASE}
	exit 1
    fi
    mount *.iso /mnt
    if [ -f /mnt/install/filesystem.squashfs ]
    then
        cp /mnt/install/filesystem.squashfs /${OUTPUT_DIR}/${LSBDISTCODENAME}/${POINT_RELEASE}/filesystem.squashfs
    elif [ -f /mnt/casper/filesystem.squashfs ]
    then
        cp /mnt/casper/filesystem.squashfs /${OUTPUT_DIR}/${LSBDISTCODENAME}/${POINT_RELEASE}/filesystem.squashfs
    else
	echo Cannot find filesystemd.squashfs for ${UBUNTU_DIST} ${POINT_RELEASE}
	exit 1
    fi
    umount /mnt
    rm *.iso
    chmod 0644 /${OUTPUT_DIR}/${LSBDISTCODENAME}/${POINT_RELEASE}/*

}

compress_xz () {
    # specifically formulated compression for use with kernel decompression
    # see https://www.kernel.org/doc/Documentation/xz.txt
    xz -9 -C crc32 --lzma2=dict=512KiB -
}

recompress_ubuntu_initrd () {
    echo 'Repack all initrd.gz to xz'
    for initrd in /${OUTPUT_DIR}/*/*/*.gz
    do
        zcat ${initrd} | compress_xz > "${initrd%%.gz}.xz"
        rm ${initrd}
    done
}

# Retrieve and extract the initial ramdisk
get_preseed_files xenial-updates 20101020ubuntu451.29 hwe-netboot 16.04.7
get_preseed_files bionic-updates 20101020ubuntu543.17 hwe-netboot 18.04.5

# Convert Ubuntu's initrd.gz to xz
recompress_ubuntu_initrd
cd /
tar -cvf  /${OUTPUT_DIR}.tar  ${OUTPUT_DIR}
