#!/bin/bash
set -x

# Install dkms driver package for i40e
apt-get install -y i40e-dkms

# find port names in team interface
TEAM_INTERFACES=()
INTERFACES=$(facter interfaces | tr , " ")
for interface in ${INTERFACES}
do
  teamdctl team0 port present "${interface}" 2>/dev/null && TEAM_INTERFACES+=("${interface}")
done

# remove ports from team interface
for interface in ${TEAM_INTERFACES[*]}
do
  # ifconfig down first otherwise we will kernel oops
  ifconfig "${interface}" down
  teamdctl team0 port remove "${interface}"
done

# unload in kernel i40e module
modprobe -r i40e
# reload i40e
modprobe i40e

# Add ports back to team interfaces
for interface in ${TEAM_INTERFACES[*]}
do
  teamdctl team0 port add "${interface}"
done
