#!/bin/bash
set -x

# Install dkms driver package for mellanox
apt-get install -y mlnx-en-dkms mlnx-en-utils

# find port names in team interface
TEAM_INTERFACES=()
INTERFACES=$(facter interfaces | tr , " ")
for interface in ${INTERFACES}
do
  teamdctl team0 port present "${interface}" 2>/dev/null && TEAM_INTERFACES+=("${interface}")
done

# remove ports from team interface
for interface in ${TEAM_INTERFACES[*]}
do
  # ifconfig down first otherwise we will kernel oops
  ifconfig "${interface}" down
  teamdctl team0 port remove "${interface}"
done

# unload in kernel mellanox modules in specific order
modprobe -r mlx5_ib ib_uverbs ib_core mlx5_core
# reload mlx5_core
modprobe mlx5_core

# Add ports back to team interfaces
for interface in ${TEAM_INTERFACES[*]}
do
  teamdctl team0 port add "${interface}"
done
