node default {

  Exec { path => [ '/bin', '/sbin', '/usr/bin', '/usr/sbin', '/usr/local/bin'] }

  class {'::up_all_interfaces': }

}

# lint:ignore:autoloader_layout
# ifup - bring up link
define ifup() {

  exec {"ip link set ${name} up":
    command   => "ip link set ${name} up",
    logoutput => true,
  }

}

# up_all_interfaces - bring up link on all interfaces
class up_all_interfaces {

  $interfaces_prep = split($::interfaces,',')

  ifup {$interfaces_prep: }

}
# lint:endignore
