#!/bin/bash
set -e -x

useradd -m jtv
apt-get update
apt-get install -y wget gnupg jq
echo "deb [arch=amd64] http://packages.internal.justin.tv/artifactory/ip-${DISTRO_CODENAME}-twitch/ ${DISTRO_CODENAME} main" >> /etc/apt/sources.list
wget -qO - https://deb.pkgs.xarth.tv/artifactory/api/gpg/key/public | apt-key add -
apt-get update

case $DISTRO_CODENAME in
	'bionic')
		apt-get install -y omnibus-puppet net-tools lsb-release netplan.io sssd
		;;
	'xenial')
		apt-get install -y puppet
		;;
esac
apt-get install -y sudo ifupdown systemd cron

wget http://s3-reverse-proxy.us-west-2.prod.provisioner.live-video.a2z.com/tftpboot/puppet_plugins.tar -O - |  tar -xf -
facter -p -j | jq -S .
apt-get purge -y wget
ln -s /bin/true /usr/bin/wget
cp /etc/hosts /etc/hosts.bak
umount /etc/hosts
cp /etc/hosts.bak /etc/hosts
cp /etc/hostname /etc/hostname.bak
umount /etc/hostname
cp /etc/hostname.bak /etc/hostname
