#!/usr/bin/env bash

set -ueo pipefail

export AWS_STS_REGIONAL_ENDPOINTS=regional

TF_S3_STATE_BUCKET="puppet-environment-renderer-us-west-2-prod-tf-state"

tf_init() {
    shift
    terraform init "$@" -reconfigure -backend-config=<(cat <<EOF
bucket = "${TF_S3_STATE_BUCKET}"
EOF
)
    terraform get -update
}

command -v tfenv &> /dev/null || {
    echo "tfenv required but missing" && exit 1
}

case "$1" in
    init) tf_init "$@" ;;
    plan|apply) tf_init "$@" && exec terraform "$@" ;;
    *) exec terraform "$@" ;;
esac
