# Permit jenkins to upload to S3
locals {
  jenkins_role = "puppet-environment-renderer-upload-role"
  deployment_envs = [
    "prod",
    "staging"
  ]
}

module "jenkins" {
  for_each      = toset(local.deployment_envs)
  source        = "git@git.xarth.tv:video-coreservices/tf-mod-jenkins-role.git?ref=v1.0.2"
  iam_role_name = "${local.jenkins_role}-${each.value}"
  s3_bucket_arn = "arn:aws:s3:::puppet-environment-renderer-bucket-${each.value}"
}

resource "aws_iam_policy" "jenkins_sqs" {
  name        = "jenkins_sqs"
  path        = "/"
  description = "SQS related permissions"
  policy      = <<EOF
{
  "Version": "2012-10-17",
  "Statement": [
    {
      "Effect": "Allow",
      "Action": [
        "sqs:*"
      ],
      "Resource": "*"
    }
  ]
}
EOF
}

resource "aws_iam_role_policy_attachment" "jenkins_sqs_role_attachment" {
  for_each   = toset(local.deployment_envs)
  role       = "${local.jenkins_role}-${each.value}"
  policy_arn = aws_iam_policy.jenkins_sqs.arn
}
