data "aws_iam_policy_document" "s3_puppet_access_prod" {
  statement {
    sid = "1"

    actions = [
      "s3:GetBucketLocation",
      "s3:GetBucketVersioning",
      "s3:GetObject",
      "s3:GetObjectVersion",
      "s3:ListBucket",
    ]

    effect = "Allow"

    resources = [
      "arn:aws:s3:::puppet-environment-renderer-bucket-prod",
      "arn:aws:s3:::puppet-environment-renderer-bucket-prod/*",
    ]

    principals {
      type = "AWS"
      identifiers = [
        "arn:aws:iam::277437172290:root",
      ]
    }
  }
}

data "aws_iam_policy_document" "s3_puppet_access_staging" {
  statement {
    sid = "1"

    actions = [
      "s3:GetBucketLocation",
      "s3:GetBucketVersioning",
      "s3:GetObject",
      "s3:GetObjectVersion",
      "s3:ListBucket",
    ]

    effect = "Allow"

    resources = [
      "arn:aws:s3:::puppet-environment-renderer-bucket-staging",
      "arn:aws:s3:::puppet-environment-renderer-bucket-staging/*",
    ]

    principals {
      type = "AWS"
      identifiers = [
        "arn:aws:iam::152548578290:root",
      ]
    }
  }
}

resource "aws_s3_bucket" "puppet_environment_renderer_bucket_prod" {
  # bucket name can't contain underscores so we use dashes instead
  bucket = "puppet-environment-renderer-bucket-prod"
  acl    = "private"
  lifecycle_rule {
    enabled = true
    expiration {
      days = 90
    }
  }
  policy = data.aws_iam_policy_document.s3_puppet_access_prod.json
}

resource "aws_s3_bucket" "puppet_environment_renderer_bucket_staging" {
  # bucket name can't contain underscores so we use dashes instead
  bucket = "puppet-environment-renderer-bucket-staging"
  acl    = "private"
  lifecycle_rule {
    enabled = true
    expiration {
      days = 90
    }
  }
  policy = data.aws_iam_policy_document.s3_puppet_access_staging.json
}

# TODO: uncomment when prod puppet5 infra will be configured
#resource "aws_s3_bucket_notification" "bucket_notification_prod" {
#  bucket = aws_s3_bucket.puppet_environment_renderer_bucket_prod.id
#
#  lambda_function {
#    lambda_function_arn = var.consumer_prod
#    events              = ["s3:ObjectCreated:*"]
#  }
#}

resource "aws_s3_bucket_notification" "bucket_notification_staging" {
  bucket = aws_s3_bucket.puppet_environment_renderer_bucket_staging.id

  lambda_function {
    lambda_function_arn = var.consumer_staging
    events              = ["s3:ObjectCreated:*"]
  }
}
