#!/bin/bash

hocon() {
  /opt/puppetlabs/puppet/lib/ruby/vendor_gems/bin/hocon "$@"
}

if [[ "${GRAPHITE_REPORTER_ENABLE}" == "true" ]]; then
    cd /etc/puppetlabs/puppetserver/conf.d
    hocon -f metrics.conf set metrics.server-id "$(hostname -f)"
    hocon -f metrics.conf set metrics.registries.puppetserver.reporters.graphite.enabled true
    hocon -f metrics.conf set metrics.reporters.graphite.host "${GRAPHITE_HOST:-127.0.0.1}"
    hocon -f metrics.conf set metrics.reporters.graphite.port "${GRAPHITE_PORT:-2003}"
    hocon -f metrics.conf set metrics.reporters.graphite.update-interval-seconds "${GRAPHITE_UPDATE_INTERVAL:-10}"
    cd /
fi
