job {
    name "vidcs-pyemf-build"
    description("build and deploy the video-pyemf pypi module")
    using 'TEMPLATE-autobuild'
    scm {
        git {
            remote {
                github 'video-coreservices/pyemf', 'ssh', 'git.xarth.tv'
                credentials 'git-aws-read-key'
            }
            clean true
            branches 'origin/*'
        }
    }

    wrappers{
        credentialsBinding {
            string('dtatoolsdeploy', 'dtatoolsdeploy')
            string('dta_tools_deploy', 'dta_tools_deploy')
        }
    }

    steps {
        conditionalSteps {
            condition {
                stringsMatch('$GIT_BRANCH', 'origin/main', true)
            }
            steps {
                shell """
                    sed -i "s/video-pyemf-staging/video-pyemf/" setup.py
                """
            }
        }

        shell """
            sed -i "s/\\.000/.\${BUILD_NUMBER}/" setup.py
            sed -i "s/\\.000/.\${BUILD_NUMBER}/" pyemf/constants.py
        """
        uploadPyPi '.'
    }
}

